﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Win32;
using Winfoot_7_SDK;

namespace WinfootDefaultNetworkPlugin.Controls.Strategy
{
    public interface IEnableDeadGWDetectStrategy
    {
        void Write(int num);
        WFRegistry Read();
        List<WFRegistry> BackUp();
    }

    public class EnableDeadGWDetectDefaultStrategy:ICorrespondenceOS,IEnableDeadGWDetectStrategy
    {
        public EnableDeadGWDetectDefaultStrategy()
        {
            CorrespondenceOSList = new List<OS>
                                       {
                                           OS.WindowsXP,
                                           OS.WindoesXP_SP1,
                                           OS.WindowsXP_SP2,
                                           OS.WindowsXP_SP3,

#if DEBUG
                                           OS.WindowsVista,
                                           OS.WindowsVista_SP1,
                                           OS.WindowsSeven
#endif
                                       };
        }

        private string RegName = "EnableDeadGWDetect";

        #region ICorrespondenceOS メンバ

        public List<OS> CorrespondenceOSList { get; set; }

        #endregion

        #region IAdditionalWorkerThreadsStrategy メンバ

        public void Write(int num)
        {
            RegistryKey registryKey =
                Registry.LocalMachine.CreateSubKey(
                    @"SYSTEM\CurrentControlSet\Services\Tcpip\Parameters");

            registryKey.SetValue(RegName, num, RegistryValueKind.DWord);
        }

        public WFRegistry Read()
        {
            RegistryKey registryKey =
                Registry.LocalMachine.OpenSubKey(
                    @"SYSTEM\CurrentControlSet\Services\Tcpip\Parameters");

            return new WFRegistry(@"HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters", RegName,
                                  registryKey.GetValue(RegName, 0), RegistryValueKind.DWord, RegOperation.ValueWrite);
        }

        public List<WFRegistry> BackUp()
        {
            return new List<WFRegistry> { Read() };
        }

        #endregion
    }

    public class EnableDeadGWDetectController
    {
        public EnableDeadGWDetectController(EnableDeadGWDetect enableDeadGWDetect,
                                                         IEnableDeadGWDetectStrategy strategy)
        {
            EnableDeadGWDetect = enableDeadGWDetect;
            Strategy = strategy;
        }

        public EnableDeadGWDetect EnableDeadGWDetect { get; set; }
        public IEnableDeadGWDetectStrategy Strategy { get; set; }

        public void Read()
        {
            EnableDeadGWDetect.SetEnableDeadGWDetectValue(Convert.ToInt32(Strategy.Read().Value));
        }

        public void Write()
        {
            Strategy.Write(EnableDeadGWDetect.GetEnableDeadGWDetectValue());
        }

        public List<WFRegistry> BackUp()
        {
            return Strategy.BackUp();
        }
    }
    class EnableDeadGWDetectStrategy
    {
    }
}
